/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.entity.client;

import io.github.fabricators_of_create.porting_lib.core.PortingLib;
import io.github.fabricators_of_create.porting_lib.entity.IEntityAdditionalSpawnData;
import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import io.github.fabricators_of_create.porting_lib.entity.mixin.common.BlockableEventLoopAccessor;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class PortingLibEntityClient
implements ClientModInitializer {
    @Environment(value=EnvType.CLIENT)
    private static void handlePacketReceived(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.method_10816();
        buf.retain();
        PortingLibEntityClient.execute(client, () -> {
            class_1297 entity = Objects.requireNonNull(client.field_1687).method_8469(entityId);
            if (entity instanceof IEntityAdditionalSpawnData) {
                IEntityAdditionalSpawnData extra = (IEntityAdditionalSpawnData)entity;
                extra.readSpawnData(buf);
            } else {
                PortingLib.LOGGER.error("ExtraSpawnDataEntity spawn data received, but no corresponding entity was found! Entity: [{}]", (Object)entity);
            }
            buf.release();
        });
    }

    private static void execute(class_310 mc, Runnable task) {
        if (mc.method_18854()) {
            task.run();
        } else {
            ((BlockableEventLoopAccessor)mc).callSubmitAsync(task);
        }
    }

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)IEntityAdditionalSpawnData.EXTRA_DATA_PACKET, PortingLibEntityClient::handlePacketReceived);
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity()) {
                for (PartEntity<?> part : partEntity.getParts()) {
                    world.getPartEntityMap().put(part.method_5628(), part);
                }
            }
        });
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity()) {
                for (PartEntity<?> part : partEntity.getParts()) {
                    world.getPartEntityMap().remove(part.method_5628());
                }
            }
        });
    }
}

